#include "DxLib.h"

int player, chip[3];
int px = 1, py = 1;
int score = 0;

int map[15][20] = {
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,0,0,0,0,0,2,2,2,2,2,2,2,1,0,0,0,0,0,1},
	{1,0,0,0,0,0,2,2,2,2,2,2,2,1,0,0,0,0,0,1},
	{1,0,0,1,1,0,0,1,1,1,0,0,0,1,1,0,0,0,0,1},
	{1,2,2,0,1,0,2,2,2,1,2,2,2,0,0,0,0,2,2,1},
	{1,2,2,0,1,0,2,2,2,1,2,2,2,0,0,0,0,2,2,1},
	{1,2,2,0,0,0,2,2,2,0,2,2,2,0,0,0,0,2,2,1},
	{1,2,2,0,0,0,1,1,1,1,1,1,1,1,0,0,0,2,2,1},
	{1,2,2,0,0,0,2,2,2,0,2,2,2,0,0,0,0,2,2,1},
	{1,2,2,0,0,0,2,2,2,1,2,2,2,0,1,0,0,2,2,1},
	{1,2,2,0,0,0,2,2,2,1,2,2,2,0,1,0,0,2,2,1},
	{1,0,0,0,1,1,0,0,0,1,1,1,0,0,1,1,0,2,2,1},
	{1,0,0,0,0,1,2,2,2,2,2,2,2,0,0,0,0,0,0,1},
	{1,0,0,0,0,1,2,2,2,2,2,2,2,0,0,0,0,0,0,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
};

int WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int) {
	ChangeWindowMode(TRUE);
	DxLib_Init();
	SetDrawScreen(DX_SCREEN_BACK);

	player = LoadGraph("player1.png");
	LoadDivGraph("chip.png", 3, 3, 1, 32, 32, chip);

	while (!ProcessMessage()) {
		ClearDrawScreen();

		int kx = px, ky = py;
		if (CheckHitKey(KEY_INPUT_LEFT)) kx--;
		if (CheckHitKey(KEY_INPUT_RIGHT)) kx++;
		if (CheckHitKey(KEY_INPUT_UP)) ky--;
		if (CheckHitKey(KEY_INPUT_DOWN)) ky++;
		if (map[ky][kx] != 1) {
			px = kx;
			py = ky;
		}
		if (map[py][px] == 2) {
			map[py][px] = 0;
			score += 10;
		}

		for (int y = 0; y < 15; y++) {
			for (int x = 0; x < 20; x++) {
				DrawGraph(x * 32, y * 32, chip[map[y][x]], FALSE);
			}
		}
		DrawGraph(px * 32, py * 32, player, FALSE);
		DrawFormatString(0, 0, GetColor(255, 255, 255), "SCORE : %d", score);
		ScreenFlip();
		WaitTimer(80);
	}

	DxLib_End();
	return 0;
}
