/* -----------------------------------------------------------------------------
	MatrixNXvZp֐
	t@C	:	mtx33.as
	as.Ver		:	AS 1.0 Flash 5 ȍ~
			:	Hakuhin	(C)	2006/08/17
 ----------------------------------------------------------------------------- */

/* -----------------------------------------------------------------------------

	--------------------------------------
	}gbNX̌^
	--------------------------------------
	matrix = {
		a  : 0 , b  : 0,
		c  : 0 , d  : 0,
		tx : 0 , ty : 0,
	};
	--------------------------------------
	
	MatrixNXƌ݊邽߂
	IuWFNg`ōsvZĂ܂B


	// sp֐ -------------------------------------------------------
	function Mtx33Create();					// Pʍs쐬
	function Mtx33Clone (m);				// s񕡐
	function Mtx33GetPos(m);				// W擾

	// sړs -----------------------------------------------------
	function Mtx33Translate(x,y);			// ss쐬
	function Mtx33TranslatePref(x,y,m);		// ss * ws
	function Mtx33TranslatePost(x,y,m);		// ws * ss

	// ]s -----------------------------------------------------
	function Mtx33Rotate(rot);				// ]s쐬
	function Mtx33RotatePref(rot,m);		// ]s * ws
	function Mtx33RotatePost(rot,m);		// ws * ]s

	// gks -----------------------------------------------------
	function Mtx33Scale(x,y);				// gks쐬
	function Mtx33ScalePref(x,y,m);			// gks * ws
	function Mtx33ScalePost(x,y,m);			// ws * gks

	// ˉeϊ ---------------------------------------------------------
	function Vec2dTransformPoint (x,y,m); 	// _̎ˉe
	function Vec2dTransformVector (x,y,m);	// xNg̎ˉe
	function Mtx33Transform  (m,m);			// s̎ˉe(s * s)

	// ts ---------------------------------------------------------
	function Mtx33InvertOrthoNormal (m); 	// t}gbNXvZ(Ksp)
	function Mtx33Invert (m);				// t}gbNXvZ

	.Mtx33Transform() ͌vZʂ̂
	*Pref *Post ֐ŌvZłƂ͂D悵Ďgp邱
 ----------------------------------------------------------------------------- */


/* ------------------------------------------------------------------- 
	}gbNX쐬
		Ȃ
	Ԃl	Pʍs
 ------------------------------------------------------------------- */
function Mtx33Create(){
	return {
		a : 1,		b : 0,
		c : 0,		d : 1,
		tx: 0,		ty: 0
	};
}


/* ------------------------------------------------------------------- 
	}gbNX
		s
	Ԃl	̍s
 ------------------------------------------------------------------- */
function Mtx33Clone(m){
	return {
		a : m.a,		b : m.b,
		c : m.c,		d : m.d,
		tx: m.tx,		ty: m.ty
	};
}


/* ------------------------------------------------------------------- 
	W擾
		擾s
	Ԃl	WxNgiIuWFNgj
 ------------------------------------------------------------------- */
function Mtx33GetPos(m){
	return {
		x :	m.tx,
		y :	m.ty
	};
}


/* ------------------------------------------------------------------- 
	ss쐬
	01	x W
	02	y W
	Ԃl		ss
 ------------------------------------------------------------------- */
function Mtx33Translate(x,y){
	return {
		a : 1,		b : 0,
		c : 0,		d : 1,
		tx: x,		ty: y
	};
}


/* ------------------------------------------------------------------- 
	sړsvZ(ss * ws)
	01	x W
	02	y W
	03	ws
	Ԃl		vZ̍s
 ------------------------------------------------------------------- */
function Mtx33TranslatePref(x,y,m){
	return {
		a : m.a,
		b : m.b,
		c : m.c,
		d : m.d,
		tx: x * m.a + y * m.c + m.tx,
		ty: x * m.b + y * m.d + m.ty
	};
}


/* ------------------------------------------------------------------- 
	sړsvZ(ws * ss)
	01	x W
	02	y W
	03	ws
	Ԃl		vZ̍s
 ------------------------------------------------------------------- */
function Mtx33TranslatePost(x,y,m){
	return {
		a : m.a,
		b : m.b,
		c : m.c,
		d : m.d,
		tx: m.tx + x,
		ty: m.ty + y
	};
}


/* ------------------------------------------------------------------- 
	]s쐬
		px
	Ԃl	]s
 ------------------------------------------------------------------- */
function Mtx33Rotate(rot){
	
	var rad = rot * Math.PI / 180;
	var cos = Math.cos(rad);
	var sin = Math.sin(rad);

	return {
		a : cos,	b : sin,
		c : -sin,	d : cos,
		tx: 0,		ty: 0
	};

}


/* ------------------------------------------------------------------- 
	]svZ(]s * ws)
	01	px
	02	ws
	Ԃl		vZ̍s
 ------------------------------------------------------------------- */
function Mtx33RotatePref(rot,m){
	
	var rad = rot * Math.PI / 180;
	var cos = Math.cos(rad);
	var sin = Math.sin(rad);
	
	return {
		a :  cos * m.a + sin * m.c,
		b :  cos * m.b + sin * m.d,
		c : -sin * m.a + cos * m.c,
		d : -sin * m.b + cos * m.d,
		tx: m.tx,
		ty: m.ty
	};

}


/* ------------------------------------------------------------------- 
	]svZ(ws * ]s)
	01	px
	02	ws
	Ԃl		vZ̍s
 ------------------------------------------------------------------- */
function Mtx33RotatePost(rot,m){
	
	var rad = rot * Math.PI / 180;
	var cos = Math.cos(rad);
	var sin = Math.sin(rad);

	return {
		a : m.a  * cos + m.b  * -sin,
		b : m.a  * sin + m.b  *  cos,
		c : m.c  * cos + m.d  * -sin,
		d : m.c  * sin + m.d  *  cos,
		tx: m.tx * cos + m.ty * -sin,
		ty: m.tx * sin + m.ty *  cos
	};
}


/* ------------------------------------------------------------------- 
	gks쐬
	01	x 
	02	y 
	Ԃl		gks
 ------------------------------------------------------------------- */
function Mtx33Scale(x,y){

	return {
		a : x,	b : 0,
		c : 0,	d : y,
		tx: 0,	ty: 0
	};
}


/* ------------------------------------------------------------------- 
	gksvZ(gks * ws)
	01	x 
	02	y 
	03	ws
	Ԃl		vZ̍s
 ------------------------------------------------------------------- */
function Mtx33ScalePref(x,y,m){
	return {
		a : x * m.a,
		b : x * m.b,
		c : y * m.c,
		d : y * m.d,
		tx: m.tx,
		ty: m.ty
	};
}


/* ------------------------------------------------------------------- 
	gksvZ(ws * gks)
	01	x 
	02	y 
	03	ws
	Ԃl		vZ̍s
 ------------------------------------------------------------------- */
function Mtx33ScalePost(x,y,m){
	return {
		a : m.a  * x,
		b : m.b  * y,
		c : m.c  * x,
		d : m.d  * y,
		tx: m.tx * x,
		ty: m.ty * y
	};
}


/* ------------------------------------------------------------------- 
	_̎ˉeϊ
	01	xW
	02	yW
	03	ws
	Ԃl		ϊ̍WxNgiIuWFNgj
 ------------------------------------------------------------------- */
function Vec2dTransformPoint(x,y,m){
	return {
		x : x * m.a + y * m.c + m.tx,
		y : x * m.b + y * m.d + m.ty
	};
}


/* ------------------------------------------------------------------- 
	xNg̎ˉeϊ
	01	x 
	02	y 
	03	ws
	Ԃl		ϊ̃xNgiIuWFNgj
 ------------------------------------------------------------------- */
function Vec2dTransformVector (x,y,m){
	return {
		x : x * m.a + y * m.c,
		y : x * m.b + y * m.d
	};
};


/* ------------------------------------------------------------------- 
	}gbNXm̌vZ
	01	Pڂ̍s
	02	Qڂ̍s
	Ԃl		vZ̍s
 ------------------------------------------------------------------- */
function Mtx33Transform  (m1,m2){
	return {
		a : m1.a * m2.a + m1.b * m2.c,
		b : m1.a * m2.b + m1.b * m2.d,
		c : m1.c * m2.a + m1.d * m2.c,
		d : m1.c * m2.b + m1.d * m2.d,
		tx: m1.tx * m2.a + m1.ty * m2.c + m2.tx,
		ty: m1.tx * m2.b + m1.ty * m2.d + m2.ty
	};
};


/* ------------------------------------------------------------------- 
	t}gbNXvZ(Ksp)
	01	Ks
	Ԃl		ts
 ------------------------------------------------------------------- */
function Mtx33InvertOrthoNormal (m){
	return {
		a : m.a,
		b : m.c,
		c : m.b,
		d : m.d,
		tx: -m.tx * m.a + -m.ty * m.b,
		ty: -m.tx * m.c + -m.ty * m.d
	};
}


/* ------------------------------------------------------------------- 
	t}gbNXvZ
	01	s
	Ԃl		ts
 ------------------------------------------------------------------- */
function Mtx33Invert (m){
	var o = {
		a : 1.0,	b : 0.0,
		c : 0.0,	d : 1.0,
		tx: 0.0,	ty: 0.0
	}

	var _01 = m.b;
	var _11 = m.d;
	var _21 = m.ty;

	if(m.a){
		o.a /= m.a;
		_01 /= m.a;
	}
	_11 -= m.c * _01;
	o.c -= m.c * o.a;
	_21 -= m.tx * _01;
	o.tx -= m.tx * o.a;

	if(_11){
		o.c /= _11;
	}
	o.tx -= _21 * o.c;
	o.a -= _01 * o.c;


	_01 = m.b;
	_11 = m.d;
	_21 = m.ty;

	if(m.a){
		o.b /= m.a;
		_01 /= m.a;
	}
	_11 -= m.c * _01;
	o.d -= m.c * o.b;
	_21 -= m.tx * _01;
	o.ty -= m.tx * o.b;

	if(_11){
		o.d /= _11;
	}
	o.ty -= _21 * o.d;
	o.b -= _01 * o.d;

	return o;
}