//=============================================================================
//	DirectDraw֌W̎֐Q
//=============================================================================
#include "common.h"
#include "ddutil.h"

//-----------------------------------------------------------------------------
// vg^Cv錾i\[XłgȂ́j
//-----------------------------------------------------------------------------
static HRESULT InitFail(HWND, HRESULT, LPCTSTR, ...); 

//-----------------------------------------------------------------------------
// Oϐij
//-----------------------------------------------------------------------------
LPDIRECTDRAW7 g_pDD = NULL;					// DirectDraw IuWFNg
LPDIRECTDRAWSURFACE7 g_pDDSPrimary = NULL;	// vC}T[tFCX
LPDIRECTDRAWSURFACE7 g_pDDSBack = NULL;		// obNobt@ 
LPDIRECTDRAWSURFACE7 g_pDDSStart = NULL;	// X^[g摜pT[tFCX
LPDIRECTDRAWSURFACE7 g_pDDSGame = NULL;		// Q[摜pT[tFCX
LPDIRECTDRAWSURFACE7 g_pDDSChara = NULL;	// LN^摜pT[tFCX
LPDIRECTDRAWSURFACE7 g_pDDSString = NULL;	// 摜pT[tFCX

//-----------------------------------------------------------------------------
// O[oϐ
//-----------------------------------------------------------------------------
static LPDIRECTDRAWPALETTE g_pDDPal = NULL;	// vC}ET[tFCXEpbg
static char szStartBmp[] = "STARTBMP";		// X^[g摜\[X
static char szGameBmp[] = "GAMEBMP";		// Q[摜\[X
static char szCharaBmp[] = "CHARABMP";		// Q[摜\[X
static char szStringBmp[] = "STRINGBMP";		// Q[摜\[X

//-----------------------------------------------------------------------------
// ֐@F@InitializeDraw()@
// @\TvF@Direct Draw IuWFNg̐
// ߂l@F@ÎƂFDD_OKAُÎƂFG[R[h
//-----------------------------------------------------------------------------
HRESULT InitializeDraw(HWND hWnd)
{
    DDSURFACEDESC2      ddsd;
    DDSCAPS2            ddscaps;
    HRESULT             hRet;

    ///////////////////////////////////////////////////////////////////////////
    // DirectDraw CIuWFNg̍쐬
    ///////////////////////////////////////////////////////////////////////////
    hRet = DirectDrawCreateEx(NULL, (VOID**)&g_pDD, IID_IDirectDraw7, NULL);
    if (hRet != DD_OK)
        return InitFail(hWnd, hRet, "DirectDrawCreateEx FAILED");

    // x̐ݒ
    hRet = g_pDD->SetCooperativeLevel(hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN | DDSCL_ALLOWREBOOT);
    if (hRet != DD_OK)
        return InitFail(hWnd, hRet, "SetCooperativeLevel FAILED");

    // rfI[h̐ݒ 640x480x8
    hRet = g_pDD->SetDisplayMode(640, 480, 8, 0, 0);
    if (hRet != DD_OK)
        return InitFail(hWnd, hRet, "SetDisplayMode FAILED");

    // vC}[T[tFCX̐
    ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
    ddsd.dwBackBufferCount = 1;
    hRet = g_pDD->CreateSurface(&ddsd, &g_pDDSPrimary, NULL);
    if (hRet != DD_OK)
        return InitFail(hWnd, hRet, "CreateSurface FAILED");

    // obNobt@̐
    ZeroMemory(&ddscaps, sizeof(ddscaps));
    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
    hRet = g_pDDSPrimary->GetAttachedSurface(&ddscaps, &g_pDDSBack);
    if (hRet != DD_OK)
        return InitFail(hWnd, hRet, "GetAttachedSurface FAILED");

	// pbg̐
	g_pDDPal = DDLoadPalette(g_pDD, szStartBmp);
	if (g_pDDPal == NULL)
		return InitFail(hWnd, hRet, "DDLoadPalette FAILED");

	// vC}ET[tFCXɃpbgݒ肷
	hRet = g_pDDSPrimary->SetPalette(g_pDDPal);
	if (hRet != DD_OK)
		return InitFail(hWnd, hRet, "SetPalette FAILED"); 

	// ItXN[T[tFCX𐶐i摜j
	/* X^[g摜 */
	g_pDDSStart = DDLoadBitmap(g_pDD, szStartBmp, 0, 0);
	if (g_pDDSStart == NULL)
		return InitFail(hWnd, hRet, "DDLoadBitmap StartBmp FAILED");
	DDSetColorKey(g_pDDSStart, RGB(32, 128, 64));	// J[L[ݒ
	/* Q[wi摜 */
	g_pDDSGame = DDLoadBitmap(g_pDD, szGameBmp, 0, 0);
	if (g_pDDSGame == NULL)
		return InitFail(hWnd, hRet, "DDLoadBitmap GameBmp FAILED");
	/* LN^摜 */
	g_pDDSChara = DDLoadBitmap(g_pDD, szCharaBmp, 0, 0);
	if (g_pDDSChara == NULL)
		return InitFail(hWnd, hRet, "DDLoadBitmap CharaBmp FAILED");
	DDSetColorKey(g_pDDSChara, CLR_INVALID);	// J[L[ݒ
	/* 摜 */
	g_pDDSString = DDLoadBitmap(g_pDD, szStringBmp, 0, 0);
	if (g_pDDSString == NULL)
		return InitFail(hWnd, hRet, "DDLoadBitmap StringBmp FAILED");
	DDSetColorKey(g_pDDSString, CLR_INVALID);	// J[L[ݒ

    return DD_OK;

}

//-----------------------------------------------------------------------------
// ֐@F@InitFail()
// @\TvF@ɎsƂ̃bZ[W\֐
// @F@InitFail(hWnd,hRet,"Err String");@@			̕\
//			   InitFail(hWnd,hRet,"Err Code %d %d", code, err); w̕\
// ߂l@F@hRet̒liG[R[hj
//-----------------------------------------------------------------------------
static HRESULT InitFail(HWND hWnd, HRESULT hRet, LPCTSTR szError,...)
{
    char        szBuff[128];
    va_list     vl;

    va_start(vl, szError);
    vsprintf(szBuff, szError, vl);
    ReleaseDraw();
    MessageBox(hWnd, szBuff, "ERROR", MB_OK);
    DestroyWindow(hWnd);
    va_end(vl);

    return hRet;

}

//-----------------------------------------------------------------------------
// ֐@F@ReleaseDraw()
// @\TvF@Direct Draw IuWFNg̍폜
//-----------------------------------------------------------------------------
void ReleaseDraw(void)
{
    if (g_pDD != NULL)
    {
        if (g_pDDSPrimary != NULL) // vC}[T[tFCX
        {
            g_pDDSPrimary->Release();
            g_pDDSPrimary = NULL;
        }
		if (g_pDDSStart != NULL)	// X^[g摜pT[tFCX
		{
			g_pDDSStart->Release();
			g_pDDSStart = NULL;
		}
		if (g_pDDSGame != NULL)		// Q[wi摜pT[tFCX
		{
			g_pDDSGame->Release();
			g_pDDSGame = NULL;
		}
		if (g_pDDSChara != NULL)	// LN^摜pT[tFCX
		{
			g_pDDSChara->Release();
			g_pDDSChara = NULL;
		}
		if (g_pDDSString != NULL)	// LN^摜pT[tFCX
		{
			g_pDDSString->Release();
			g_pDDSString = NULL;
		}
        g_pDD->Release(); // DirectDrawIuWFNg
        g_pDD = NULL;
    }

}

//-----------------------------------------------------------------------------
// ֐@F@StringDraw()
// @\TvF@̕`
// @@F@*str:\̐擪AhX
// @@@@@@x, y:]W
// @@@@@@colorNo:Fԍi摜̂PiځAQiځAEEEj
//-----------------------------------------------------------------------------
BOOL StringDraw(char *str, DWORD x, DWORD y, int colorNo)
{
    HRESULT     hRet;
    RECT        strRect;
    DWORD       i, j, wx;

	strRect.top = colorNo * 16;
	strRect.bottom = strRect.top + 16;
    for(i = 0; i < strlen(str); i++)
    {
        wx = i * 8 + x;
        j = str[i] - ' ';
        strRect.left = j * 8;
        strRect.right = strRect.left + 8;

        hRet = g_pDDSBack->BltFast(wx, y, g_pDDSString, &strRect, DDBLTFAST_SRCCOLORKEY);
        if (hRet != DD_OK)
            return FALSE;
    }

    return TRUE;
}