(function($) {
  $.fn.ipop = function(options) {
    return this.each(function() {
      var setting = $.extend({
        left: 'center',
        top: 'center',
        zIndex: 999,
        titleSelector: '.title',
        closeSelector: '.close',
        closeFunc: null
      }, options);
      var closeFunc = setting['closeFunc'];
      var container = $(this);
      var left = setting['left']
      var top = setting['top'];
      if (left == 'center') {
        left = $(document).scrollLeft() + ($(window).width() - container.outerWidth()) / 2;
        if (left < 0) left = 0;
      }
      if (top == 'center') {
        top = $(document).scrollTop() + ($(window).height() - container.outerHeight()) / 2;
        if (top < 0) top = 0;
      }
      container.css({
        left: left,
        top: top,
        position: 'absolute',
        zIndex: setting['zIndex']
      }).hide();
      $(this).find(setting['closeSelector']).click(function() {
        container.hide();
        if (closeFunc) closeFunc();
      });
      $(this).find(setting['titleSelector']).mousedown(function(e) {
        var mx = e.pageX;
        var my = e.pageY;
        $(document).on('mousemove.ipop', function(e) {
          container.css({
            left: '+=' + (e.pageX - mx) + 'px',
            top: '+=' + (e.pageY - my) + 'px'
          });
          mx = e.pageX;
          my = e.pageY;
          return false;
        }).one('mouseup', function(e) {
          $(document).off('mousemove.ipop');
        });
        return false;
      });
    });
  };
})(jQuery);
