#include <string>
#include <list>
#include <map>
#include <algorithm>
#include "DxLib.h"

enum ChrType {TYPE_NONE, TYPE_SHOT, TYPE_PLAYER, TYPE_ENEMY, TYPE_CLOUD, TYPE_NUM};

class Chr;
typedef std::shared_ptr<Chr> ChrRef;

// LN^{NX
class Chr {
	static int loaded_images[TYPE_NUM];
	bool remove_flag;
protected:
	int image;
	int x, y;
	int width, height;
	int hit_x, hit_y;
	int hit_width, hit_height;
	void remove() {remove_flag = true;}
public:
	Chr();
	void setImage(char*);
	void setPosition(int, int);
	void setHitArea(int, int, int, int);
	bool isRemove() {return remove_flag;}
	virtual ChrType getType() = 0;
	virtual ChrType hitType() {return TYPE_NONE;}
	virtual void move() = 0;
	virtual void draw();
	bool hitTest(ChrRef&);
	virtual void hit() {};
};
int Chr::loaded_images[] = {};

// eNX
class Shot : public Chr {
public:
	Shot();
	ChrType getType() {return TYPE_SHOT;}
	ChrType hitType() {return TYPE_ENEMY;}
	void move();
	void hit();
};

// vC[NX
class Player : public Chr {
	bool shot_flag;
	int dead_time;
public:
	Player();
	ChrType getType() {return TYPE_PLAYER;}
	void move();
	void draw();
	void hit();
};

// GNX
class Enemy : public Chr {
public:
	Enemy();
	ChrType getType() {return TYPE_ENEMY;}
	ChrType hitType() {return TYPE_PLAYER;}
	void move();
	void hit();
};

// _NX
class Cloud : public Chr {
	int speed;
	void resetPosition(bool);
public:
	static const int NUM = 25;
	Cloud();
	ChrType getType() {return TYPE_CLOUD;}
	void move();
};

// Q[NX
class Game {
	std::list<ChrRef> chr_list;
	int score;
public:
	static const int WIDTH = 640;
	static const int HEIGHT = 480;
	static Game* me;
	void addList(ChrRef&);
	void addScore(int s) {score += s;}
	void init();
	void main();
	void end();
};
Game* Game::me;

// LN^NX o֐

Chr::Chr() {
	remove_flag = false;
}

void Chr::setImage(char* file_name) {
	if (loaded_images[getType()] == 0) {
		loaded_images[getType()] = LoadGraph(file_name);
	}
	image = loaded_images[getType()];
	GetGraphSize(image, &width, &height);
	hit_width = width;
	hit_height = height;
	hit_x = hit_y = 0;
}

void Chr::setPosition(int px, int py) {
	x = px; y = py;
}

void Chr::setHitArea(int hx, int hy, int hw, int hh) {
	hit_x = hx; hit_y = hy;
	hit_width = hw; hit_height = hh;
}

void Chr::draw() {
	DrawGraph(x, y, image, TRUE);
}

bool Chr::hitTest(ChrRef& dst) {
	int x1 = x + hit_x;
	int y1 = y + hit_y;
	int w1 = hit_width;
	int h1 = hit_height;
	int x2 = dst->x + dst->hit_x;
	int y2 = dst->y + dst->hit_y;
	int w2 = dst->hit_width;
	int h2 = dst->hit_height;
	if (x1 + w1 > x2 && x1 < x2 + w2 && y1 + h1 > y2 && y1 < y2 + h2) return true;
	return false;
}

// eNX o֐

Shot::Shot() {
	setImage("shot.png");
}

void Shot::move() {
	x += 12;
	if (x > Game::WIDTH) remove();
}

void Shot::hit() {
	remove();
}

// vC[NX o֐

Player::Player() {
	setImage("player.png");
	setPosition(30, 200);
	setHitArea(14, 12, 36, 16);
	shot_flag = false;
	dead_time = 0;
}

void Player::move() {
	if (dead_time > 0) {
		dead_time--;
		return;
	}
	if (CheckHitKey(KEY_INPUT_LEFT)) x -= 6;
	if (CheckHitKey(KEY_INPUT_RIGHT)) x += 6;
	if (CheckHitKey(KEY_INPUT_UP)) y -= 6;
	if (CheckHitKey(KEY_INPUT_DOWN)) y += 6;
	if (x < -hit_x) x = -hit_x;
	if (x > Game::WIDTH - hit_x - hit_width) x = Game::WIDTH - hit_x - hit_width;
	if (y < -hit_y) y = -hit_y;
	if (y > Game::HEIGHT - hit_y - hit_height) y = Game::HEIGHT - hit_y - hit_height;
	if (CheckHitKey(KEY_INPUT_SPACE)) {
		if (!shot_flag) {
			ChrRef shot(new Shot());
			shot->setPosition(x + width - 16, y + 16);
			Game::me->addList(shot);
			shot_flag = true;
		}
	} else {
		shot_flag = false;
	}
}

void Player::draw() {
	if (dead_time % 5 == 0) Chr::draw();
}

void Player::hit() {
	dead_time = 50;
}

// GNX o֐

Enemy::Enemy() {
	setImage("enemy.png");
	setPosition(Game::WIDTH, GetRand(Game::HEIGHT - height));
}

void Enemy::move() {
	x -= 4;
	if (x < -width) remove();
}

void Enemy::hit() {
	Game::me->addScore(100);
	remove();
}

// _NX o֐

Cloud::Cloud() {
	setImage("cloud.png");
	resetPosition(true);
}

void Cloud::resetPosition(bool init) {
	int cx = GetRand(Game::WIDTH + width) - width;
	int cy = GetRand(Game::HEIGHT + height) - height;
	if (init) setPosition(cx, cy);
	else setPosition(Game::WIDTH, cy);
	speed = GetRand(4) + 2;
}

void Cloud::move() {
	x -= speed;
	if (x < -width) resetPosition(false);
}

// Q[NX o֐

void Game::addList(ChrRef& c) {
	chr_list.push_back(c);
}

void Game::init() {
	me = this;
	score = 0;
	ChangeWindowMode(TRUE);
	SetGraphMode(Game::WIDTH, Game::HEIGHT, 32);
	DxLib_Init();
	SetDrawScreen(DX_SCREEN_BACK);
	SetBackgroundColor(124, 210, 255);
	// _
	for (int i = 0; i < Cloud::NUM; i++) {
		ChrRef cloud(new Cloud());
		addList(cloud);
	}
	// vC[
	ChrRef player(new Player());
	addList(player);
}

void Game::main() {
	while (!ProcessMessage()) {
		ClearDrawScreen();
		// G
		if (GetRand(49) == 0) {
			ChrRef enemy(new Enemy());
			addList(enemy);
		}
		// ړ
		std::for_each(chr_list.begin(), chr_list.end(), [](ChrRef& c) {c->move();});
		// `
		std::for_each(chr_list.begin(), chr_list.end(), [](ChrRef& c) {c->draw();});
		// 蔻
		std::for_each(chr_list.begin(), chr_list.end(), [&](ChrRef& src) {
			if (src->hitType() == TYPE_NONE) return;
			std::for_each(chr_list.begin(), chr_list.end(), [&](ChrRef& dst) {
				if (src->hitType() == dst->getType()) {
					if (src->hitTest(dst)) {
						src->hit();
						dst->hit();
					}
				}
			});
		});
		// XRA\
		DrawFormatString(Game::WIDTH - 120, 5, GetColor(0, 0, 0), "SCORE %d", score);
		ScreenFlip();
		// ׂLN^̏
		auto end = std::remove_if(chr_list.begin(), chr_list.end(), [](ChrRef& c) {return c->isRemove();});
		chr_list.erase(end, chr_list.end());
	}
}

void Game::end() {
	DxLib_End();
}

// WinMain
int WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int) {
	Game game;
	game.init();
	game.main();
	game.end();
	return 0;
}
