#include "DxLib.h"

int player, chip[3];
int px = 1, py = 1;

int map[15][20] = {
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
	{1,0,0,0,0,0,2,2,2,2,2,2,2,1,0,0,0,0,0,1},
	{1,0,0,0,0,0,2,2,2,2,2,2,2,1,0,0,0,0,0,1},
	{1,0,0,1,1,0,0,1,1,1,0,0,0,1,1,0,0,0,0,1},
	{1,2,2,0,1,0,2,2,2,1,2,2,2,0,0,0,0,2,2,1},
	{1,2,2,0,1,0,2,2,2,1,2,2,2,0,0,0,0,2,2,1},
	{1,2,2,0,0,0,2,2,2,0,2,2,2,0,0,0,0,2,2,1},
	{1,2,2,0,0,0,1,1,1,1,1,1,1,1,0,0,0,2,2,1},
	{1,2,2,0,0,0,2,2,2,0,2,2,2,0,0,0,0,2,2,1},
	{1,2,2,0,0,0,2,2,2,1,2,2,2,0,1,0,0,2,2,1},
	{1,2,2,0,0,0,2,2,2,1,2,2,2,0,1,0,0,2,2,1},
	{1,0,0,0,1,1,0,0,0,1,1,1,0,0,1,1,0,2,2,1},
	{1,0,0,0,0,1,2,2,2,2,2,2,2,0,0,0,0,0,0,1},
	{1,0,0,0,0,1,2,2,2,2,2,2,2,0,0,0,0,0,0,1},
	{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
};

int WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int) {
	ChangeWindowMode(TRUE);
	DxLib_Init();
	SetDrawScreen(DX_SCREEN_BACK);

	player = LoadGraph("player1.png");
	LoadDivGraph("chip.png", 3, 3, 1, 32, 32, chip);

	while (!ProcessMessage()) {
		ClearDrawScreen();

		if (CheckHitKey(KEY_INPUT_LEFT)) px--;
		if (CheckHitKey(KEY_INPUT_RIGHT)) px++;
		if (CheckHitKey(KEY_INPUT_UP)) py--;
		if (CheckHitKey(KEY_INPUT_DOWN)) py++;

		for (int y = 0; y < 15; y++) {
			for (int x = 0; x < 20; x++) {
				DrawGraph(x * 32, y * 32, chip[map[y][x]], FALSE);
			}
		}
		DrawGraph(px * 32, py * 32, player, FALSE);
		ScreenFlip();
		WaitTimer(80);
	}

	DxLib_End();
	return 0;
}
