import java.awt.*;
import java.awt.event.*;

class MFrame extends Frame
{
    public MFrame() {                            
        addWindowListener(new MyWindowAdapter());
        addMouseListener(new MyMouseAdapter());
    }

    class MyWindowAdapter extends WindowAdapter
    {
        public void windowClosing(WindowEvent e) {
            System.exit(0);                        
        }
    }

    class MyMouseAdapter extends MouseAdapter
    {
        public void mouseClicked(MouseEvent e) {
            Graphics g = getGraphics();
            g.fillOval(e.getX() - 20, e.getY() - 20, 40, 40);
            g.dispose();
        }
    }
}

class MouseApp
{
    public static void main(String[] args){
        MFrame f = new MFrame();
        f.setSize(500,500);
        f.setVisible(true);
    }
}
