import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

class ImPanel extends JPanel
{
    private Image img;
    private String str;
    ImPanel() {
        setPreferredSize(new Dimension(400, 300));
    }
    void setPlaceData(Place p) {
        if(img != null) img.flush();
        MediaTracker tr = new MediaTracker(this);
        img = Toolkit.getDefaultToolkit().getImage(p.getName() + ".jpg");
        tr.addImage(img, 0);
        try{ tr.waitForID(0); }catch(InterruptedException e) {}
        str = p.getName() + "    " + "ꏊ|CgF" + p.getPoint() + "";
    }
    void setEnd() {
        if(img != null) img.flush();
        img = null;
        str = "Q[I[o[";
    }
    public void paintComponent(Graphics g){
        super.paintComponent(g);
        g.drawImage(img, 0, 0, null);
        g.drawString(str, 40, 280);
    }
}

class AdvGame3 extends JFrame
{
    private ImPanel cp = new ImPanel();

    private int num = 4;
    private int pos = 0;
    private Hero h = new Hero(5);
    private Place[] pls = new Place[num];

    private void showData() {
        setTitle("݂̃|CgF" + h.getPoint());
        if(h.getPoint() <= 0) {
            setTitle("cOI܂ł");
            cp.setEnd();
        }
        if(pos == num - 1) {
            setTitle("S[I    ŏI|CgF" + h.getPoint());
        }
        cp.setPlaceData(pls[pos]);
        repaint();
    }

    AdvGame3() {
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        JButton b1 = new JButton("֍s");
        b1.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if(h.getPoint() <= 0 || pos == num - 1) return;
                pos = pls[pos].getN(1);
                pls[pos].effect(h);
                showData();
            }
        });
        JButton b2 = new JButton("E֍s");
        b2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if(h.getPoint() <= 0 || pos == num - 1) return;
                pos = pls[pos].getN(2);
                pls[pos].effect(h);
                showData();
            }
        });

        JPanel p = new JPanel();
        p.add(b1);
        p.add(b2);
        Container pane = getContentPane();
        pane.add(cp, "Center");
        pane.add(p, "South");
        pack();

        pls[0] = new Place("", 2, 1, 2);
        pls[1] = new Place("", 1, 2, 3);
        pls[2] = new Place("", -5, 1, 3);
        pls[3] = new Place("X", 3, 3, 3);

        pls[pos].effect(h);
        showData();
    }

    void play() {
        setVisible(true);
    }
}
