import java.io.*;
import java.util.*;

class Person
{
    private String name;
    private String address;
    Person(String n, String a){
        name = n;
        address = a;
    }

    String getName(){
        return name;
    }
    void setName(String n){
        name = n;
    }
    String getAddress(){
        return address;
    }
    void setAddress(String a){
        address = a;
    }
}

class AddressBook
{
    private ArrayList<Person> ppl = new ArrayList<Person>();

    private void showAll() {
        System.out.println();
        for(int i = 0; i < ppl.size(); i++){
            System.out.println("ԍF" + (i + 1));
            System.out.println(ppl.get(i).getName());
            System.out.println(ppl.get(i).getAddress());
            System.out.println("-----");
        }
    }

    private void addPerson() {
        Scanner sc = new Scanner(System.in);
        String n, a;
        System.out.print("ÓF");
        n = sc.nextLine();
        System.out.print("ŹF");
        a = sc.nextLine();
        ppl.add(new Person(n, a));
    }

    private void delPerson() {
        Scanner sc = new Scanner(System.in);
        int n;
        System.out.print("폜l̔ԍ́F");
        n = sc.nextInt ();
        if(n <= 0 || n > ppl.size()) return;
        ppl.remove(n - 1);
    }

    private void saveAll() {
        PrintStream ps = null;
        try {
            ps = new PrintStream(new File("ppl.txt"));
            for(int i = 0; i < ppl.size(); i++){
                ps.println(ppl.get(i).getName());
                ps.println(ppl.get(i).getAddress());
            }
        }
        catch(Exception e) {
            e.printStackTrace();
            System.out.println("ۑɎs܂");
        }
        finally {
            if(ps != null) ps.close();
        }
    }

    AddressBook() {
        String str, n, a;
        Scanner sc = null;
        try {
            sc = new Scanner(new File("ppl.txt"));
            while(sc.hasNext()) {
                n = sc.next();
                a = sc.next();
                ppl.add(new Person(n, a));
            }
        }
        catch(Exception e) {
            System.out.println("ppl.txt͂܂ł");
        }
        finally {
            if(sc != null) sc.close();
        }
    }

    void proc() {
        Scanner sc = new Scanner(System.in);
        int ans;
        for(;;){
            System.out.println("\nFǂ܂H");
            System.out.println("1 ꗗ@2 ǉ@3 폜@4 ۑ@5 I");
            ans = sc.nextInt();
            if(ans == 1){
                showAll();
            }
            else if(ans == 2){
                addPerson();
            }
            else if(ans == 3) {
                delPerson();
            }
            else if(ans == 4) {
                saveAll();
            }
            else {
                break;
            }
        }
    }
}

class ABManager
{
    public static void main(String[] args)
    {
        AddressBook ab = new AddressBook();
        ab.proc();
    }
}
